/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.schemaspy.input.dbms.ConnectionConfig;
import org.schemaspy.input.dbms.MissingParameterException;
import org.schemaspy.util.DbSpecificOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionURLBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ConnectionConfig connectionConfig;

    public ConnectionURLBuilder(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
    }

    public String build() {
        ArrayList args = new ArrayList();
        args.addAll(this.connectionConfig.getRemainingArguments());
        String connectionURL = this.connectionConfig.getDatabaseTypeProperties().getProperty("connectionSpec");
        List options = this.connectionConfig.getDbSpecificConfig().getOptions();
        for (DbSpecificOption option : options) {
            option.setValue(this.getParam(args, option));
            LOGGER.debug("{}", (Object)option);
            connectionURL = connectionURL.replaceAll("<" + option.getName() + ">", option.getValue());
        }
        LOGGER.trace("connectionURL: {}", (Object)connectionURL);
        return connectionURL;
    }

    private String getParam(List<String> args, DbSpecificOption option) {
        String param = null;
        int paramIndex = args.indexOf("-" + option.getName());
        if (paramIndex < 0) {
            if ("db".equals(option.getName())) {
                param = this.connectionConfig.getDatabaseName();
            }
            if ("host".equals(option.getName())) {
                param = this.connectionConfig.getHost();
            }
            if ("port".equals(option.getName())) {
                String string = param = Objects.nonNull(this.connectionConfig.getPort()) ? this.connectionConfig.getPort().toString() : null;
            }
            if ("hostOptionalPort".equals(option.getName())) {
                param = this.getHostOptionalPort();
            }
            if (param == null) {
                throw new MissingParameterException(option.getName(), option.getDescription());
            }
        } else {
            args.remove(paramIndex);
            param = args.get(paramIndex);
            args.remove(paramIndex);
        }
        return param;
    }

    private String getHostOptionalPort() {
        String hostOptionalPort = this.connectionConfig.getHost();
        if (hostOptionalPort == null) {
            throw new MissingParameterException("host", "host of database, may contain port");
        }
        String hostPortSeparator = this.connectionConfig.getDatabaseTypeProperties().getProperty("hostPortSeparator", ":");
        Integer port = this.connectionConfig.getPort();
        if (hostOptionalPort.contains(hostPortSeparator)) {
            return hostOptionalPort;
        }
        if (port != null) {
            return hostOptionalPort + hostPortSeparator + port;
        }
        return hostOptionalPort;
    }
}

