/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.html.mustache.diagrams;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import org.schemaspy.model.Table;
import org.schemaspy.output.diagram.DiagramResult;
import org.schemaspy.output.diagram.TableDiagram;
import org.schemaspy.output.dot.schemaspy.DotFormatter;
import org.schemaspy.util.DefaultPrintWriter;
import org.schemaspy.util.naming.FileNameGenerator;
import org.schemaspy.view.MustacheTableDiagram;

/*
 * Exception performing whole class analysis ignored.
 */
public class MustacheTableDiagramFactory {
    private final DotFormatter dotProducer;
    private final TableDiagram diagramFactory;
    private final File tableDir;
    private final int degreeOfSeparation;

    public MustacheTableDiagramFactory(DotFormatter dotProducer, TableDiagram diagramFactory, File outputDir, int degreeOfSeparation) {
        this.dotProducer = dotProducer;
        this.diagramFactory = diagramFactory;
        this.tableDir = outputDir.toPath().resolve("diagrams").resolve("tables").toFile();
        this.tableDir.mkdirs();
        this.degreeOfSeparation = degreeOfSeparation;
    }

    public List<MustacheTableDiagram> generateTableDiagrams(Table table) throws IOException {
        ArrayList<MustacheTableDiagram> diagrams = new ArrayList<MustacheTableDiagram>();
        diagrams.addAll(this.generateRealTableDiagrams(table));
        diagrams.addAll(this.generateImpliedTableDiagrams(table));
        return diagrams;
    }

    public List<MustacheTableDiagram> generateRealTableDiagrams(Table table) throws IOException {
        ArrayList<MustacheTableDiagram> diagrams = new ArrayList<MustacheTableDiagram>();
        String fileNameBase = new FileNameGenerator(table.getName()).value();
        File oneDegreeDotFile = new File(this.tableDir, fileNameBase + ".1degree.dot");
        File twoDegreesDotFile = new File(this.tableDir, fileNameBase + ".2degrees.dot");
        Files.deleteIfExists(oneDegreeDotFile.toPath());
        Files.deleteIfExists(twoDegreesDotFile.toPath());
        LongAdder oneStats = new LongAdder();
        try (DefaultPrintWriter dotOut = new DefaultPrintWriter(oneDegreeDotFile);){
            this.dotProducer.writeTableRealRelationships(table, false, oneStats, (PrintWriter)dotOut);
        }
        DiagramResult results = this.diagramFactory.generateTableDiagram(oneDegreeDotFile, fileNameBase + ".1degree");
        MustacheTableDiagram oneDiagram = new MustacheTableDiagram("One", results, false);
        oneDiagram.setActive(true);
        diagrams.add(oneDiagram);
        if (this.degreeOfSeparation == 2) {
            LongAdder twoStats = new LongAdder();
            try (DefaultPrintWriter dotOut = new DefaultPrintWriter(twoDegreesDotFile);){
                this.dotProducer.writeTableRealRelationships(table, true, twoStats, (PrintWriter)dotOut);
            }
            if (MustacheTableDiagramFactory.sameWritten((LongAdder)oneStats, (LongAdder)twoStats)) {
                Files.deleteIfExists(twoDegreesDotFile.toPath());
            } else {
                DiagramResult resultsTwo = this.diagramFactory.generateTableDiagram(twoDegreesDotFile, fileNameBase + ".2degrees");
                MustacheTableDiagram twoDiagram = new MustacheTableDiagram("Two degrees", resultsTwo, false);
                diagrams.add(twoDiagram);
            }
        }
        return diagrams;
    }

    public List<MustacheTableDiagram> generateImpliedTableDiagrams(Table table) throws IOException {
        ArrayList<MustacheTableDiagram> diagrams = new ArrayList<MustacheTableDiagram>();
        String fileNameBase = new FileNameGenerator(table.getName()).value();
        File oneImpliedDotFile = new File(this.tableDir, fileNameBase + ".implied1degrees.dot");
        File twoImpliedDotFile = new File(this.tableDir, fileNameBase + ".implied2degrees.dot");
        Files.deleteIfExists(oneImpliedDotFile.toPath());
        Files.deleteIfExists(twoImpliedDotFile.toPath());
        if (table.hasImpliedConstraints(this.degreeOfSeparation)) {
            LongAdder oneImplied = new LongAdder();
            try (DefaultPrintWriter dotOut = new DefaultPrintWriter(oneImpliedDotFile);){
                this.dotProducer.writeTableAllRelationships(table, false, oneImplied, (PrintWriter)dotOut);
            }
            DiagramResult results = this.diagramFactory.generateTableDiagram(oneImpliedDotFile, fileNameBase + ".implied1degrees");
            MustacheTableDiagram oneImpliedDiagram = new MustacheTableDiagram("One implied", results, true);
            diagrams.add(oneImpliedDiagram);
            if (this.degreeOfSeparation == 2) {
                LongAdder twoImplied = new LongAdder();
                try (DefaultPrintWriter dotOut = new DefaultPrintWriter(twoImpliedDotFile);){
                    this.dotProducer.writeTableAllRelationships(table, true, twoImplied, (PrintWriter)dotOut);
                }
                if (MustacheTableDiagramFactory.sameWritten((LongAdder)oneImplied, (LongAdder)twoImplied)) {
                    Files.deleteIfExists(twoImpliedDotFile.toPath());
                } else {
                    DiagramResult resultsTwo = this.diagramFactory.generateTableDiagram(twoImpliedDotFile, fileNameBase + ".implied2degrees");
                    MustacheTableDiagram twoImpliedDiagram = new MustacheTableDiagram("Two implied", resultsTwo, true);
                    diagrams.add(twoImpliedDiagram);
                }
            }
        }
        return diagrams;
    }

    private static boolean sameWritten(LongAdder first, LongAdder second) {
        return first.sum() == second.sum();
    }
}

