/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.view;

import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.schemaspy.view.MustacheCatalog;
import org.schemaspy.view.MustacheCompiler;
import org.schemaspy.view.MustacheSchema;
import org.schemaspy.view.PageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlMultipleSchemasIndexPage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MustacheCompiler mustacheCompiler;

    public HtmlMultipleSchemasIndexPage(MustacheCompiler mustacheCompiler) {
        this.mustacheCompiler = mustacheCompiler;
    }

    public void write(MustacheCatalog catalog, List<MustacheSchema> schemas, String description, String productName, Writer writer) {
        String connectTime = ZonedDateTime.now().format(DateTimeFormatter.ofPattern("EEE MMM dd HH:mm z yyyy"));
        PageData pageData = new PageData.Builder().templateName("multi.html").addToScope("description", (Object)description).addToScope("connectTime", (Object)connectTime).addToScope("databaseProduct", (Object)productName).addToScope("schemas", schemas).addToScope("catalog", (Object)catalog).addToScope("schemasNumber", (Object)Integer.toString(schemas.size())).addToScope("isMultipleSchemas", (Object)true).getPageData();
        try {
            this.mustacheCompiler.write(pageData, writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write multischema index", (Throwable)e);
        }
    }
}

