<?php

/**
 * sdoh form
 *
 * @package   OpenEMR
 * @link      https://www.open-emr.org
 * @author    Char Miller <charjmiller@gmail.com>
 * @copyright Copyright (c) 2022 Char Miller <charjmiller@gmail.com>
 * @license   https://github.com/openemr/openemr/blob/master/LICENSE GNU General Public License 3
 */

// block of code to securely support use by the patient portal
//   since need this class before autoloader, need to manually include it and then set it in line below with use command
require_once(__DIR__ . "/../../../src/Common/Forms/CoreFormToPortalUtility.php");
use OpenEMR\Common\Forms\CoreFormToPortalUtility;

// block of code to securely support use by the patient portal
$patientPortalSession = CoreFormToPortalUtility::isPatientPortalSession($_GET);
if ($patientPortalSession) {
    $ignoreAuth_onsite_portal = true;
}
$patientPortalOther = CoreFormToPortalUtility::isPatientPortalOther($_GET);

require_once(__DIR__ . "/../../globals.php");
require_once("$srcdir/api.inc.php");
require_once("$srcdir/forms.inc.php");

use OpenEMR\Common\Csrf\CsrfUtils;

if (!CsrfUtils::verifyCsrfToken($_POST["csrf_token_form"])) {
    CsrfUtils::csrfNotVerified();
}

if ($encounter == "") {
    $encounter = date("Ymd");
}

if ($_GET["mode"] == "new") {
    $newid = formSubmit("form_sdoh", $_POST, '', $userauthorized);
    addForm($encounter, "Social Screening Tool", $newid, "sdoh", $pid, $userauthorized);
    $formid = $newid;
} elseif ($_GET["mode"] == "update") {
    // if running from patient portal, then below will ensure patient can only see their forms
    CoreFormToPortalUtility::confirmFormBootstrapPatient($patientPortalSession, $_GET['id'], 'sdoh', $_SESSION['pid']);
    $formid = $_GET["id"];
    sqlStatement(
        "UPDATE form_sdoh set pid = ?,
            groupname=?,
            user=?,
            authorized=?,
            activity=1,
            date = NOW(),
education=? ,
disability=? ,
housing=? ,
housingotherinput=? ,
workfulltime=? ,
workparttime=? ,
worktemporary=? ,
workseasonal=? ,
worklooking=? ,
workretired=? ,
workdisabled=? ,
workstudent=? ,
worknotemployed=? ,
worknotans=? ,
workhours=? ,
hhincome=? ,
hhsize=? ,
careno=? ,
careunder5=? ,
care5to12=? ,
careover12=? ,
carespecneeds=? ,
caredisabled=? ,
careelderly=? ,
careother=? ,
careotherinput=? ,
debtno=? ,
debtmedical=? ,
debtcreditcards=? ,
debtrent=? ,
debtstudentloans=? ,
debttaxes=? ,
debtlegal=? ,
debtcar=? ,
debtutilities=? ,
debtother=? ,
debtotherinput=? ,
moneyno=? ,
moneyfood=? ,
moneymedical=? ,
moneychildcare=? ,
moneyutilities=? ,
moneyphone=? ,
moneyrent=? ,
moneytransportation=? ,
moneyclothing=? ,
moneyeducation=? ,
moneyother=? ,
moneyotherinput=? ,
transportationno=? ,
transportmedical=? ,
transportfood=? ,
transportwork=? ,
transportschool=? ,
transportfamily=? ,
transportother=? ,
transportotherinput=? ,
medicalno=? ,
medicalnoinsurance=? ,
medicalcopay=? ,
medicalnotcovered=? ,
medicalwork=? ,
medicalnoprovider=? ,
medicalunderstand=? ,
medicaltrust=? ,
medicalchildcare=? ,
medicalother=? ,
medicalotherinput=? ,
dentist=? ,
dentistotherinput=? ,
social=? ,
stress=? ,
stressno=? ,
stressdeath=? ,
stressdivorce=? ,
stressjob=? ,
stressmoved=? ,
stressillness=? ,
stressvictim=? ,
stresswitness=? ,
stresslegal=? ,
stresshomeless=? ,
stressincarcerated=? ,
stressbankruptcy=? ,
stressmarriage=? ,
stressbirth=? ,
stressadultchild=? ,
stressother=? ,
stressotherinput=? ,
safety=? ,
partnersafety=? ,
female=? ,
addiction=? ,
armedservices=? ,
refugee=? ,
discrimno=? ,
discrimrace=? ,
discrimgender=? ,
discrimsexpref=? ,
discrimgenexp=? ,
discrimreligion=? ,
discrimdisability=? ,
discrimage=? ,
discrimweight=? ,
discrimses=? ,
discrimedu=? ,
discrimmarital=? ,
discrimcitizen=? ,
discrimaccent=? ,
discrimcriminalhist=? ,
discrimother=? ,
discrimotherinput=? ,
displaceno=? ,
displacework=? ,
displacehousing=? ,
displacehealth=? ,
displacelaw=? ,
displaceedu=? ,
displacepublic=? ,
displaceclubs=? ,
displacegovt=? ,
displacefinance=? ,
displaceother=? ,
displaceotherinput=? ,
contact=? ,
contactotherinput=? ,
totalscore=? ,
additional_notes=?
WHERE id=?",
        [
            $_SESSION["pid"],
            $_SESSION["authProvider"] ?? null,
            $_SESSION["authUser"],
            $userauthorized,
            ($_POST["education"] ?? null),
        ($_POST["disability"] ?? null),
        ($_POST["housing"] ?? null),
        ($_POST["housingotherinput"] ?? ''),
        ($_POST["workfulltime"] ?? null),
        ($_POST["workparttime"] ?? null),
        ($_POST["worktemporary"] ?? null),
        ($_POST["workseasonal"] ?? null),
        ($_POST["worklooking"] ?? null),
        ($_POST["workretired"] ?? null),
        ($_POST["workdisabled"] ?? null),
        ($_POST["workstudent"] ?? null),
        ($_POST["worknotemployed"] ?? null),
        ($_POST["worknotans"] ?? null),
        ($_POST["workhours"] ?? null),
        ($_POST["hhincome"] ?? null),
        ($_POST["hhsize"] ?? null),
        ($_POST["careno"] ?? null),
        ($_POST["careunder5"] ?? null),
        ($_POST["care5to12"] ?? null),
        ($_POST["careover12"] ?? null),
        ($_POST["carespecneeds"] ?? null),
        ($_POST["caredisabled"] ?? null),
        ($_POST["careelderly"] ?? null),
        ($_POST["careother"] ?? null),
        ($_POST["careotherinput"] ?? ''),
        ($_POST["debtno"] ?? null),
        ($_POST["debtmedical"] ?? null),
        ($_POST["debtcreditcards"] ?? null),
        ($_POST["debtrent"] ?? null),
        ($_POST["debtstudentloans"] ?? null),
        ($_POST["debttaxes"] ?? null),
        ($_POST["debtlegal"] ?? null),
        ($_POST["debtcar"] ?? null),
        ($_POST["debtutilities"] ?? null),
        ($_POST["debtother"] ?? null),
        ($_POST["debtotherinput"] ?? ''),
        ($_POST["moneyno"] ?? null),
        ($_POST["moneyfood"] ?? null),
        ($_POST["moneymedical"] ?? null),
        ($_POST["moneychildcare"] ?? null),
        ($_POST["moneyutilities"] ?? null),
        ($_POST["moneyphone"] ?? null),
        ($_POST["moneyrent"] ?? null),
        ($_POST["moneytransportation"] ?? null),
        ($_POST["moneyclothing"] ?? null),
        ($_POST["moneyeducation"] ?? null),
        ($_POST["moneyother"] ?? null),
        ($_POST["moneyotherinput"] ?? ''),
        ($_POST["transportationno"] ?? null),
        ($_POST["transportmedical"] ?? null),
        ($_POST["transportfood"] ?? null),
        ($_POST["transportwork"] ?? null),
        ($_POST["transportschool"] ?? null),
        ($_POST["transportfamily"] ?? null),
        ($_POST["transportother"] ?? null),
        ($_POST["transportotherinput"] ?? ''),
        ($_POST["medicalno"] ?? null),
        ($_POST["medicalnoinsurance"] ?? null),
        ($_POST["medicalcopay"] ?? null),
        ($_POST["medicalnotcovered"] ?? null),
        ($_POST["medicalwork"] ?? null),
        ($_POST["medicalnoprovider"] ?? null),
        ($_POST["medicalunderstand"] ?? null),
        ($_POST["medicaltrust"] ?? null),
        ($_POST["medicalchildcare"] ?? null),
        ($_POST["medicalother"] ?? null),
        ($_POST["medicalotherinput"] ?? ''),
        ($_POST["dentist"] ?? null),
        ($_POST["dentistotherinput"] ?? ''),
        ($_POST["social"] ?? null),
        ($_POST["stress"] ?? null),
        ($_POST["stressno"] ?? null),
        ($_POST["stressdeath"] ?? null),
        ($_POST["stressdivorce"] ?? null),
        ($_POST["stressjob"] ?? null),
        ($_POST["stressmoved"] ?? null),
        ($_POST["stressillness"] ?? null),
        ($_POST["stressvictim"] ?? null),
        ($_POST["stresswitness"] ?? null),
        ($_POST["stresslegal"] ?? null),
        ($_POST["stresshomeless"] ?? null),
        ($_POST["stressincarcerated"] ?? null),
        ($_POST["stressbankruptcy"] ?? null),
        ($_POST["stressmarriage"] ?? null),
        ($_POST["stressbirth"] ?? null),
        ($_POST["stressadultchild"] ?? null),
        ($_POST["stressother"] ?? null),
        ($_POST["stressotherinput"] ?? ''),
        ($_POST["safety"] ?? null),
        ($_POST["partnersafety"] ?? null),
        ($_POST["female"] ?? null),
        ($_POST["addiction"] ?? null),
        ($_POST["armedservices"] ?? null),
        ($_POST["refugee"] ?? null),
        ($_POST["discrimno"] ?? null),
        ($_POST["discrimrace"] ?? null),
        ($_POST["discrimgender"] ?? null),
        ($_POST["discrimsexpref"] ?? null),
        ($_POST["discrimgenexp"] ?? null),
        ($_POST["discrimreligion"] ?? null),
        ($_POST["discrimdisability"] ?? null),
        ($_POST["discrimage"] ?? null),
        ($_POST["discrimweight"] ?? null),
        ($_POST["discrimses"] ?? null),
        ($_POST["discrimedu"] ?? null),
        ($_POST["discrimmarital"] ?? null),
        ($_POST["discrimcitizen"] ?? null),
        ($_POST["discrimaccent"] ?? null),
        ($_POST["discrimcriminalhist"] ?? null),
        ($_POST["discrimother"] ?? null),
        ($_POST["discrimotherinput"] ?? ''),
        ($_POST["displaceno"] ?? null),
            ($_POST["displacework"] ?? null),
        ($_POST["displacehousing"] ?? null),
        ($_POST["displacehealth"] ?? null),
        ($_POST["displacelaw"] ?? null),
        ($_POST["displaceedu"] ?? null),
        ($_POST["displacepublic"] ?? null),
        ($_POST["displaceclubs"] ?? null),
        ($_POST["displacegovt"] ?? null),
        ($_POST["displacefinance"] ?? null),
        ($_POST["displaceother"] ?? null),
        ($_POST["displaceotherinput"] ?? ''),
        ($_POST["contact"] ?? null),
        ($_POST["contactotherinput"] ?? ''),
        ($_POST["totalscore"] ?? null),
        ($_POST["additional_notes"] ?? null),
            $_GET["id"]
        ]
    );
}

if ($patientPortalSession || $patientPortalOther) {
    echo CoreFormToPortalUtility::formPatientPortalPostSave($formid);
} else {
    formHeader("Redirecting....");
    formJump();
    formFooter();
}
